.H 1 "Unix Pi Window"
.P
The Unix Pi window attaches the debugger to Unix processes
and core dumps, and is the first window created when 
pi is started.
Pi provides several options for attaching to programs.
Programs may be started from within the debugger,
or the debugger may attach to existing Unix processes.
A running program may be attached to by typing its process id number to the
window,
or the mouse may be used to list your current processes
and select the ones you want to examine.
When a process is opened pi gives you the option to create a new
window hierarchy to examine it, or to take over an existing window
hierarchy that you have already set up to debug a different instance
of the same program.
.P
Pi does not provide a window for the standard input and output of a process,
under the assumption that if the process needs terminal I/O services,
it will be started outside of pi and dynamic binding will be used to attach
to it.
Programs started from within pi have their standard input, output,
and error file descriptors initialized to the special device /dev/null.
.P
If you start a program outside of pi,
it may execute a fair amount of code before you can
attach the debugger to it.
If the program is short and does not make any system calls that
block, it will probably exit before you get a chance to see what it is doing.
To debug the first instructions in these circumstances, there is a
Unix program called hang (provided with the pi software) that starts
a new process using the exec system call, and suspends it before it executes
the first instruction by sending it a SIGSTOP signal.
Pi may then attach to the suspended process.
The syntax of hang is:
.DS I N
hang program [arg1 ...]
.DE
.P
Hang outputs the process id and name of program on its standard
error file descriptor before the program starts.
For example, if the shell's prompt is the character `$',
the following is the output of starting the program t with hang:
.DS I N
$ hang t
2854 t
.DE
.P
Hang's output is in one of the formats accepted by the Unix Pi window's
keyboard interpreter, so to attach pi to a program started with hang quickly:
.AL 1
.LI
Put hang's output into the cut buffer of the window system
.LI
Select the Unix Pi window
.LI
Paste the cut buffer into the Keyboard Input window.
.LE
.H 2 "Unix Pi Layout"
Each line in the Unix Pi window represents either
a Unix process, a core dump, or a command line used to start a new process.
Lines that start with numbers, such as
.DS I N
2292 q0 S 0:55 pads
2294 test1
.DE
.P
represent Unix processes.
The number on the left of the line is the process id, while the
rest of the line is the name of the program or the output from the
Unix ps command.
Lines that start with the character `!', such as
.DS I N
! a.out
.DE
.P
start new processes under the control of the debugger.
The rest of the line is the command to run. The other lines, such as
.DS I N
core a.out
.DE
.P
open core dumps.
The file on the left is the name of the core dump and
the file on the right is the name of the program that generated it.
.P
The core dump and !command lines are typed in from the keyboard,
while lines representing Unix processes may be either typed in or
generated by running the Unix ps command from the window's "ps" menu.
By selecting a line and generating its line menu, you may attach the
debugger to the running program, examine the core dump, or start a new program.
.P
When the Unix Pi window is initially opened, it contains two default lines:
.DS I N
!a.out
core a.out
.DE
.P
that allow the program a.out to be started,
or the core dump, core, created by an errant a.out to be opened.
These lines also serve as templates to remind you of
the window's keyboard syntax.
.H 2 "Unix Pi Menu Bar"
.P
The menu bar in the Unix Pi window allows you to list selected groups of
processes in the window, bring up the help window, or quit the debugger.
The "ps" menu contains the following entries on Unix System VR4
based systems (the entries may be slightly different with other versions
of the Unix operating system):
.VL 17 1
.LI "/bin/ps -u user"
Run the Unix command in the menu entry to generate a list of your
current processes, and place its output in the window.
You may attach the debugger to a process
by selecting its line and using its line menu.
The lines are sorted by process id number, and previous entries
with the same process id number are removed.
.LI "/bin/ps -a"
Same as above except the processes owned by other users are also listed.
Unless you have super-user permissions obtained with the Unix command su,
you will not be able to attach to programs you do not own.
.LI "/bin/ps -e"
List every process on the system.
Only the super-user is allowed to attach
to programs owned by others.
.LE
.P
The "help" and "quit" buttons do the following:
.VL 17 1
.LI "help"
Open the Help window.
.LI "quit"
Quit the debugger and detach from all processes.
A pop-up window will ask you to confirm this choice.
.LE
.H 2 "Unix Pi Keyboard"
.P
Syntax
.DS I N
!program [arg1 ...]
[*]pid [program]
[*]corefile program
.DE
.P
The Unix Pi window's keyboard interpreter accepts three different input formats
that allow you to start a new process, attach to an existing process,
or examine a core dump.
The first format:
.DS I N
!program [arg1 ...]
.DE
.P
starts a new process from pi.
Program is the name of the executable file that 
contains the code and symbol table information.
The optional arguments are passed to the program when it is started.
When the text is entered, pi adds a line to the window and selects it,
but does not start the program.
The line's menu provides options to start the program in a new Process window
or to take over an existing set of windows.
Since entering the line in the window is a separate operation from
starting the program, the same line may be used to start the
program several times.
.P
The second format:
.DS I N
[*]pid [program]
.DE
.P
attaches to processes that are already running.
Pid is the process id number and program is the name of the file containing
the symbol table.
If the operating system supports mounted processes the program name
is optional and if not present, the system will open
the correct file automatically.
Mounted processes are currently supported on systems running Unix System
VR4 and its derivatives.
If a program name is given pi searches for it on your PATH.
If not preceded by the optional `*',
the line will simply be entered in the window and you will
have to use the line's menu to attach the debugger to the process.
The line menu gives you the option of opening the process in a new set of
windows or attaching to a preexisting set, just like the menu for lines
that start with `!'.
If the entry is preceded by the character `*', a new Process window for
the process will be automatically opened when the text is entered.
`*' is an accelerator for selecting the "open process" menu entry
in the newly entered line.
.P
The third format:
.DS I N
[*]corefile program
.DE
.P
examines core dumps.
Corefile is the name of the core dump file, usually core, and program
is the name of the file containing the symbol table.
As the syntax for core dumps is the same as that used for attaching
to processes, the Unix Pi window distinguishes the two by the name
of the corefile.
If corefile contains only digits, pi assumes it is a process id.
Otherwise, its a core dump file.
If you plan to use pi with core dumps, don't rename the core file with
a name that contains only digits!
As above, the optional `*' is an accelerator for opening the core
dump without using the menus.
In the current implementation a core dump cannot take over an
existing set of windows.
.H 2 "Unix Pi Line Menus"
.P
The line menu depends on the format of the selected line.
Lines in the format "!program [arg1 ...]" start new processes and
the menu contains the following entries:
.VL 19 1
.LI "hang & open proc"
Start the process from the debugger using the execp() system call,
and suspend it before it executes the first instruction.
The program may be in any directory on your PATH.
As pi does not provide a process with a window for terminal I/O,
the new process will have its standard input, output and error file
descriptors initialized to /dev/null.
Other than redirection of the file descriptors, this
is equivalent to using hang to start the process outside of pi.
After the process is created, a new Process window is opened for it and a
new entry of the form:
.DS I N
pid program
.DE
.P
where pid is the process id of the new process,
is added to the Unix Pi window.
.LI "hang & take over"
This entry is similar to "hang & open proc",
except rather than creating a new set of windows,
you will be asked to choose an existing set of windows to take over.
A pop-up window will ask you to select the process window
hierarchy to take over.
To work successfully, the process chosen must be another instance of the
same program.
If successful, the debugger will detach itself from the Unix process that
window was previously connected to, and attach to the new one.
In addition to the windows, the new process inherits all the breakpoints
that were set in the previous process.
This menu entry is particularly useful if while debugging a program,
you discover you have gone too far, and would like to rerun the
program without going through the effort of opening the windows,
resetting the data formatting options, and placing the breakpoints.
.LE
.P
If the line in the pi window starts with a process id number,
either from a line typed to the window or from the output of the
ps command, the menu contains the following entries:
.VL 15 1
.LI "open process"
Attach the debugger to the process and open a new Process window for it.
On systems with the /proc file system, pi will locate the
file containing the symbol table automatically.
On other systems the file containing the symbol table
must be in the current directory or somewhere on your PATH to successfully
open the process.
On systems without /proc, if the line was generated by a ps menu entry
the program name is taken from the COMMAND field.
.LI "take over"
Similar to "open process", except instead of creating a new set of
windows, you will be asked to choose an existing set of windows to take over.
.LI "open child"
Attach the debugger to the child of a debugged process.
When a process being debugged calls the Unix system call fork,
the child process inherits the parent's memory, and thus any breakpoints
that were set in the code.
When the debugger attaches to the child, the breakpoints inherited
from the parent must first be removed.
To use this entry:
.AL 1
.LI
Execute the fork() in the parent process at full speed.
.LI
Choose the "ps" entry in the menu bar.
.LI
Select the line in the window corresponding to the new child process.
.LI
Choose the "open child" entry in the line menu.
.LE
.LE
.P
If the line starts with neither `!' or a process id (all digits),
the line must be in the format used to open core dumps, "corefile program",
and the menu contains:  
.VL 17 1
.LI "open coredump"
Open the Process window for the core dump.
Corefile must be accessible from the current directory as pi does
not search for it on your PATH.
.LE
